/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.svg.parsing;

import beaver.Scanner;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.xml.core.parsing.XMLParser;
import com.aptana.xml.core.parsing.ast.XMLElementNode;
import java.io.IOException;

public class SVGParser
extends XMLParser {
    private String fSource;

    private int advanceToCloseTag(String elementName) {
        int start = -1;
        try {
            this.advance();
            while (this.fCurrentLexeme.getId() != 0) {
                if (this.fCurrentLexeme.getId() == 9) {
                    start = this.fCurrentLexeme.getStart() - 1;
                    this.advance();
                    String text = (String)this.fCurrentLexeme.value;
                    if (text.equals(elementName)) {
                        this.advance();
                        ((ParseNode)this.fCurrentElement).setLocation(this.fCurrentElement.getStartingOffset(), this.fCurrentLexeme.getEnd());
                        this.closeElement();
                        return start;
                    }
                }
                this.advance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    protected void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        try {
            this.fSource = parseState.getSource();
            super.parse(parseState, working);
        }
        finally {
            this.fSource = null;
        }
    }

    private void processLanguage(String language, String elementName) throws Scanner.Exception, IOException {
        int startingOffset = this.fCurrentLexeme.getEnd() + 1;
        int endingOffset = this.advanceToCloseTag(elementName);
        String source = this.getSource(startingOffset, endingOffset);
        try {
            IParseRootNode result = ParserPoolFactory.parse((String)language, (String)source, (int)startingOffset).getRootNode();
            this.fCurrentElement.addChild((IParseNode)result);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processEndTag();
    }

    private String getSource(int start, int end) {
        return this.fSource.substring(start, end + 1);
    }

    protected void processStartTag() throws Scanner.Exception, IOException {
        XMLElementNode element;
        super.processStartTag();
        if (this.fCurrentElement instanceof XMLElementNode && !(element = (XMLElementNode)this.fCurrentElement).isSelfClosing()) {
            String elementName = element.getName();
            if ("script".equals(elementName)) {
                this.processLanguage("com.aptana.contenttype.js", elementName);
            } else if ("style".equals(elementName)) {
                this.processLanguage("com.aptana.contenttype.css", elementName);
            }
        }
    }
}

